/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSProviderMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public abstract class JAXWSServerMetaDataBuilder
extends JAXWSMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSServerMetaDataBuilder.class);

    static void setupProviderOrWebService(ArchiveDeployment dep, UnifiedMetaData umd, Class<?> beanClass, String beanName) throws Exception {
        if (beanClass.isAnnotationPresent(WebService.class)) {
            JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
            builder.buildWebServiceMetaData((Deployment)dep, umd, beanClass, beanName);
        } else if (beanClass.isAnnotationPresent(WebServiceProvider.class)) {
            JAXWSProviderMetaDataBuilder builder = new JAXWSProviderMetaDataBuilder();
            builder.buildProviderMetaData(dep, umd, beanClass, beanName);
        }
    }

    protected void processEndpointConfig(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> wsClass, String linkName) {
        EJBArchiveMetaData ejbMetaData;
        JSEArchiveMetaData jseMetaData;
        String configName = null;
        String configFile = null;
        EndpointConfig anEndpointConfig = wsClass.getAnnotation(EndpointConfig.class);
        if (anEndpointConfig != null) {
            if (anEndpointConfig.configName().length() > 0) {
                configName = anEndpointConfig.configName();
            }
            if (anEndpointConfig.configFile().length() > 0) {
                configFile = anEndpointConfig.configFile();
            }
        }
        if ((jseMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class)) != null) {
            if (jseMetaData.getConfigName() != null) {
                configName = jseMetaData.getConfigName();
            }
            if (jseMetaData.getConfigFile() != null) {
                configFile = jseMetaData.getConfigFile();
            }
        }
        if ((ejbMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null) {
            if (ejbMetaData.getConfigName() != null) {
                configName = ejbMetaData.getConfigName();
            }
            if (ejbMetaData.getConfigFile() != null) {
                configFile = ejbMetaData.getConfigFile();
            }
        }
        if (configName != null || configFile != null) {
            sepMetaData.setConfigName(configName, configFile);
        }
    }

    protected void processWebContext(Deployment dep, Class<?> wsClass, String linkName, ServerEndpointMetaData sepMetaData) {
        WebContext anWebContext = wsClass.getAnnotation(WebContext.class);
        if (anWebContext == null) {
            return;
        }
        boolean isJSEEndpoint = WSHelper.isJaxwsJseDeployment((Deployment)dep);
        if (anWebContext.contextRoot().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONTEXTROOT_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String contextRoot = anWebContext.contextRoot();
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                sepMetaData.setContextRoot(contextRoot);
            }
        }
        if (anWebContext.urlPattern().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"URLPATTERN_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String urlPattern = anWebContext.urlPattern();
                sepMetaData.setURLPattern(urlPattern);
            }
        }
        if (anWebContext.authMethod().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"AUTHMETHOD_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String authMethod = anWebContext.authMethod();
                sepMetaData.setAuthMethod(authMethod);
            }
        }
        if (anWebContext.transportGuarantee().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"TRANSPORTGUARANTEE_IS_ONLY_VALID_ON_EJB_ENDPOINTS", (Object[])new Object[0]));
            } else {
                String transportGuarantee = anWebContext.transportGuarantee();
                sepMetaData.setTransportGuarantee(transportGuarantee);
            }
        }
        sepMetaData.setSecureWSDLAccess(anWebContext.secureWSDLAccess());
    }

    protected void processWSDDContribution(Deployment dep, ServerEndpointMetaData sepMetaData) {
        WebservicesMetaData webservices = (WebservicesMetaData)dep.getAttachment(WebservicesMetaData.class);
        if (webservices != null) {
            for (WebserviceDescriptionMetaData wsDesc : webservices.getWebserviceDescriptions()) {
                for (PortComponentMetaData portComp : wsDesc.getPortComponents()) {
                    String wsdlFile;
                    MTOMFeature feature;
                    UnifiedHandlerChainsMetaData chainWrapper;
                    boolean doesMatch;
                    String portCompSEI = portComp.getServiceEndpointInterface();
                    boolean bl = doesMatch = portCompSEI != null ? portCompSEI.equals(sepMetaData.getServiceEndpointInterfaceName()) : false;
                    if (!doesMatch) {
                        doesMatch = portComp.getWsdlPort().equals(sepMetaData.getPortName());
                    }
                    if (!doesMatch) continue;
                    log.debug((Object)"Processing 'webservices.xml' contributions on EndpointMetaData");
                    if (portComp.getWsdlPort() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Override EndpointMetaData portName " + sepMetaData.getPortName() + " with " + portComp.getWsdlPort()));
                        }
                        sepMetaData.setPortName(portComp.getWsdlPort());
                    }
                    if ((chainWrapper = portComp.getHandlerChains()) != null) {
                        for (UnifiedHandlerChainMetaData handlerChain : chainWrapper.getHandlerChains()) {
                            for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Contribute handler from webservices.xml: " + uhmd.getHandlerName()));
                                }
                                HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                                sepMetaData.addHandler(hmd);
                            }
                        }
                    }
                    if (portComp.isMtomEnabled()) {
                        log.debug((Object)"Enabling MTOM");
                        feature = new MTOMFeature(true, portComp.getMtomThreshold());
                        sepMetaData.getFeatures().addFeature((WebServiceFeature)feature);
                    }
                    if (portComp.isAddressingEnabled()) {
                        log.debug((Object)"Enabling Addressing");
                        AddressingFeature.Responses responses = this.getAddressFeatureResponses(portComp.getAddressingResponses());
                        AddressingFeature feature2 = new AddressingFeature(true, portComp.isAddressingRequired(), responses);
                        sepMetaData.getFeatures().addFeature((WebServiceFeature)feature2);
                    }
                    if (portComp.isRespectBindingEnabled()) {
                        log.debug((Object)"Enabling RespectBinding Feature");
                        feature = new RespectBindingFeature(true);
                        sepMetaData.getFeatures().addFeature((WebServiceFeature)feature);
                    }
                    if ((wsdlFile = portComp.getWebserviceDescription().getWsdlFile()) == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Override wsdlFile location with " + wsdlFile));
                    }
                    sepMetaData.getServiceMetaData().setWsdlFile(wsdlFile);
                }
            }
        }
    }
}

