/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.as.security.SecurityMessages;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;

public class SecurityDomainContext {
    static final String ACTIVE_SUBJECT = "subject";
    static final String AUTHENTICATION_MGR = "authenticationMgr";
    static final String AUTHORIZATION_MGR = "authorizationMgr";
    static final String AUDIT_MGR = "auditMgr";
    static final String MAPPING_MGR = "mappingMgr";
    static final String IDENTITY_TRUST_MGR = "identityTrustMgr";
    static final String DOMAIN_CONTEXT = "domainContext";
    static final String JSSE = "jsse";
    AuthenticationManager authenticationMgr;
    AuthorizationManager authorizationMgr;
    AuditManager auditMgr;
    MappingManager mappingMgr;
    IdentityTrustManager identityTrustMgr;
    JSSESecurityDomain jsseSecurityDomain;
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";

    public SecurityDomainContext(AuthenticationManager authenticationMgr) {
        this.authenticationMgr = authenticationMgr;
    }

    public Object lookup(String name) throws NamingException {
        Object binding = null;
        if (name == null || name.length() == 0) {
            throw SecurityMessages.MESSAGES.nullName();
        }
        if (name.equals(ACTIVE_SUBJECT)) {
            binding = this.getSubject();
        } else if (name.equals(AUTHENTICATION_MGR)) {
            binding = this.getAuthenticationManager();
        } else if (name.equals(AUTHORIZATION_MGR)) {
            binding = this.getAuthorizationManager();
        } else if (name.equals(AUDIT_MGR)) {
            binding = this.getAuditManager();
        } else if (name.equals(MAPPING_MGR)) {
            binding = this.getMappingManager();
        } else if (name.equals(IDENTITY_TRUST_MGR)) {
            binding = this.getIdentityTrustManager();
        } else if (name.equals(DOMAIN_CONTEXT)) {
            binding = this;
        } else if (name.equals(JSSE)) {
            binding = this.getJSSE();
        }
        return binding;
    }

    public Subject getSubject() {
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
        return subject;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationMgr;
    }

    public void setAuthenticationManager(AuthenticationManager am) {
        this.authenticationMgr = am;
    }

    public void setAuthorizationManager(AuthorizationManager am) {
        this.authorizationMgr = am;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationMgr;
    }

    public AuditManager getAuditManager() {
        return this.auditMgr;
    }

    public void setAuditManager(AuditManager auditMgr) {
        this.auditMgr = auditMgr;
    }

    public MappingManager getMappingManager() {
        return this.mappingMgr;
    }

    public void setMappingManager(MappingManager mappingMgr) {
        this.mappingMgr = mappingMgr;
    }

    public IdentityTrustManager getIdentityTrustManager() {
        return this.identityTrustMgr;
    }

    public void setIdentityTrustManager(IdentityTrustManager identityTrustMgr) {
        this.identityTrustMgr = identityTrustMgr;
    }

    public JSSESecurityDomain getJSSE() {
        return this.jsseSecurityDomain;
    }

    public void setJSSE(JSSESecurityDomain jsseSecurityDomain) {
        this.jsseSecurityDomain = jsseSecurityDomain;
    }
}

