/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.service.SarSubsystemAdd;
import org.jboss.as.service.SarSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SarExtension
implements Extension {
    public static final String NAMESPACE = "urn:jboss:domain:sar:1.0";
    public static final String SUBSYSTEM_NAME = "sar";
    static final SarSubsystemParser parser = new SarSubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(SarSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)SarSubsystemAdd.INSTANCE, SarSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)SarDescribeHandler.INSTANCE, (DescriptionProvider)SarDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, SarSubsystemProviders.SUBSYSTEM_REMOVE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class SarDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final SarDescribeHandler INSTANCE = new SarDescribeHandler();

        private SarDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.getResult().add(SarExtension.createAddOperation());
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class SarSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        SarSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(SarExtension.NAMESPACE, false);
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            list.add(SarExtension.createAddOperation());
        }
    }
}

