/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.MessageFactoryImpl;

public class SOAPMessageUnMarshaller
implements UnMarshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPMessageUnMarshaller.class);
    private static Logger log = Logger.getLogger(SOAPMessageUnMarshaller.class);

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata, Map<String, Object> headers) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            SOAPMessage soapMsg = this.getMessageFactory().createMessage(null, inputStream, false);
            return soapMsg;
        }
        catch (SOAPException e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_SOAPMESSAGE", (Object[])new Object[0]), (Throwable)e);
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
    }

    protected MessageFactoryImpl getMessageFactory() {
        return new MessageFactoryImpl();
    }
}

