/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public abstract class AbstractHandlerChainsMetaDataParser {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AbstractHandlerChainsMetaDataParser.class);

    protected UnifiedHandlerChainsMetaData parseHandlerChains(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        return this.parseHandlerChains(reader, nsUri, nsUri, "handler-chains");
    }

    protected UnifiedHandlerChainsMetaData parseHandlerChains(XMLStreamReader reader, String nsUri, String handlerChainsElementNS, String handlerChainsElementName) throws XMLStreamException {
        UnifiedHandlerChainsMetaData handlerChains = new UnifiedHandlerChainsMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, handlerChainsElementNS, handlerChainsElementName)) {
                        return handlerChains;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "handler-chain")) {
                        handlerChains.addHandlerChain(this.parseHandlerChain(reader, nsUri));
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    private UnifiedHandlerChainMetaData parseHandlerChain(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        UnifiedHandlerChainMetaData handlerChain = new UnifiedHandlerChainMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "handler-chain")) {
                        return handlerChain;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "port-name-pattern")) {
                        handlerChain.setPortNamePattern(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-name-pattern")) {
                        handlerChain.setServiceNamePattern(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "protocol-bindings")) {
                        handlerChain.setProtocolBindings(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        handlerChain.addHandler(this.parseHandler(reader, nsUri, handlerChain));
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    protected UnifiedHandlerMetaData parseHandler(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        return this.parseHandler(reader, nsUri, null);
    }

    private UnifiedHandlerMetaData parseHandler(XMLStreamReader reader, String nsUri, UnifiedHandlerChainMetaData handlerChain) throws XMLStreamException {
        UnifiedHandlerMetaData handler = new UnifiedHandlerMetaData(handlerChain);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        return handler;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "handler-name")) {
                        handler.setHandlerName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler-class")) {
                        handler.setHandlerClass(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "init-param")) {
                        handler.addInitParam(this.parseInitParam(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "soap-role")) {
                        handler.addSoapRole(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "soap-header")) {
                        handler.addSoapHeader(StAXUtils.elementAsQName(reader));
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }

    private UnifiedInitParamMetaData parseInitParam(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        UnifiedInitParamMetaData initParam = new UnifiedInitParamMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "init-param")) {
                        return initParam;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "param-name")) {
                        initParam.setParamName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "param-value")) {
                        initParam.setParamValue(StAXUtils.elementAsString(reader));
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }
}

