/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MaskedAddressValidator
extends ModelTypeValidator {
    public MaskedAddressValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, true);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            MaskedAddressValidator.parseMasked(value);
        }
    }

    public static ParsedResult parseMasked(ModelNode value) throws OperationFailedException {
        String[] split = value.asString().split("/");
        if (split.length != 2) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAddressMaskValue(value.asString()));
        }
        try {
            InetAddress address = InetAddress.getByName(split[0]);
            int mask = Integer.parseInt(split[1]);
            int max = address.getAddress().length * 8;
            if (mask > max) {
                throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], "> " + max));
            }
            if (mask < 0) {
                throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], "< 0"));
            }
            return new ParsedResult(address, mask);
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAddressValue(split[0], e.getLocalizedMessage()));
        }
        catch (NumberFormatException e) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], e.getLocalizedMessage()));
        }
    }

    public static class ParsedResult {
        public InetAddress address;
        public int mask;

        public ParsedResult(InetAddress address, int mask) {
            this.address = address;
            this.mask = mask;
        }
    }
}

